/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.melting;

import dev.architectury.fluid.FluidStack;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_2561;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.rei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.rei.melting.MeltingDisplay;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class FoundryCategory
extends AbstractMeltingCategory {
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "foundry.title");
    private static final IRecipeTooltipReplacement METAL_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.METAL);
    private static final IRecipeTooltipReplacement GEM_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.GEM);
    private final Renderer icon = EntryStacks.of(TinkerSmeltery.foundryController);

    public CategoryIdentifier<MeltingDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.FOUNDRY;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public void addWidgets(MeltingDisplay display, List<Widget> ingredients, Point origin, Rectangle bounds) {
        super.addWidgets(display, ingredients, origin, bounds);
        ingredients.add((Widget)this.slot(24, 18, origin).markInput().disableBackground().entries((Collection)display.getInputEntries().get(0)));
        IMeltingContainer.OreRateType oreType = display.getOreType();
        IRecipeTooltipReplacement tooltip = oreType == IMeltingContainer.OreRateType.METAL ? METAL_ORE_TOOLTIP : (oreType == IMeltingContainer.OreRateType.GEM ? GEM_ORE_TOOLTIP : MeltingFluidCallback.INSTANCE);
        AlloyRecipeCategory.drawVariableFluids(ingredients, false, 96, 4, origin, 32, 32, display.getRecipe().getOutputWithByproducts(), 81000L, tooltip);
        Slot renderSlot = this.slot(4, 4, origin).disableBackground().entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(MeltingFuelHandler.getUsableFuels(display.getTemperature()))));
        TinkersCategory.setEntryTooltip(renderSlot, FUEL_TOOLTIP);
        renderSlot.getBounds().setSize(14, 34);
        ingredients.add((Widget)renderSlot);
    }

    public Renderer getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        private final IMeltingContainer.OreRateType oreRate;

        @Override
        protected boolean appendMaterial(FluidStack stack, List<class_2561> list) {
            return FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), Config.COMMON.foundryOreRate.applyOreBoost(this.oreRate, stack.getAmount()), list);
        }

        public MeltingFluidCallback(IMeltingContainer.OreRateType oreRate) {
            this.oreRate = oreRate;
        }

        public IMeltingContainer.OreRateType getOreRate() {
            return this.oreRate;
        }
    }
}

